#!/bin/bash

DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd -P)"
${DIR}/../bin/xprofiler --xputx --cpu -d &> xprofiler.log &
pid=$!

export XPU_ENABLE_PROFILER_TRACING=1
export XPU_TRACING_OUTPUT_NAME=${PWD}/xprofiler.sock
export NVTX_INJECTION64_PATH=${DIR}/../so/libxpuToolsExt.so
export XPUTX_RUN_MODE=client
export XPUTX_LISTEN_ADDR=unix:${PWD}/xputx.sock

python3 ${DIR}/example.py

kill -TERM $pid
sleep 2
if ps -p $pid > /dev/null; then
    kill -KILL $pid
fi
